//============================================================================
// Name        : OpenCVHoughCircle.cpp
// Author      : Ruediger Knoerig
// Version     :
// Copyright   : GPL
// Description : Hello World in C++, Ansi-style
//============================================================================

#include <iostream>
#include "cv.h"
#include "highgui.h"
#include <string>
#include <vector>

using namespace std;
using namespace cv;
// Test
int main() {
	try {

		VideoCapture cap(0); // open the default camera
		if (!cap.isOpened()) throw string("Konnte keine Kamera aktivieren!");
		Mat bild,graustufen;
		namedWindow("Anzeige", 1);
		for (;;) {
			cap >> bild; // get a new frame from camera
			cvtColor(bild, graustufen, CV_BGR2GRAY);
			GaussianBlur( graustufen, graustufen,Size(9,9), 2, 2 );
			vector<Vec3f> circles;
			HoughCircles(graustufen, circles, CV_HOUGH_GRADIENT,
			                 2, graustufen.rows >> 1, 200, 120 );
			for(vector<Vec3f>::const_iterator it =circles.begin();it != circles.end(); it++)
			{
				Vec3f c = *it;
				rectangle(bild,Point(cvRound(c[0]-c[2]),cvRound(c[1]-c[2])),Point(cvRound(c[0]+c[2]),cvRound(c[1]+c[2])),Scalar(0,255,0));
			}

			imshow("Anzeige",bild);
			if (waitKey(30) >= 0)
				break;
		}
		vector<int> attribute(2);
		attribute[0] = CV_IMWRITE_JPEG_QUALITY;
		attribute[1] = 90;
		imwrite(string("Bild.jpg"), bild, attribute);
		return 0;
	} catch (string msg) {
		cerr << "Ein Fehler ist aufgetreten!" << endl << msg << endl;
		return -1;
	}
}

